unit Sugo_Pld;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Buttons, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    imlRozsa: TImageList;
    imlKutyus: TImageList;
    imlKiadojel: TImageList;
    imgKep: TImage;
    cmdStart: TButton;
    MainMenu1: TMainMenu;
    mnuFajl: TMenuItem;
    mnuKilep: TMenuItem;
    mnuKep: TMenuItem;
    mnuRozsa: TMenuItem;
    mnuKutyus: TMenuItem;
    mnuKiadojel: TMenuItem;
    mnuTetelek: TMenuItem;
    mnuTetel1: TMenuItem;
    mnuTetel2: TMenuItem;
    mnuTobbTetel: TMenuItem;
    mnuSugo: TMenuItem;
    mnuTemakorok: TMenuItem;
    tmrIdozito: TTimer;
    procedure cmdStartClick(Sender: TObject);
    procedure mnuKilepClick(Sender: TObject);
    procedure mnuTetel1Click(Sender: TObject);
    procedure mnuTetel2Click(Sender: TObject);
    procedure mnuTobbTetelClick(Sender: TObject);
    procedure mnuTemakorokClick(Sender: TObject);
    procedure mnuRozsaClick(Sender: TObject);
    procedure mnuKutyusClick(Sender: TObject);
    procedure mnuKiadojelClick(Sender: TObject);
    procedure tmrIdozitoTimer(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cmdStartMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);


  private
     { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  
implementation
  const
    KepSzam = 3;
  var
    KontextSzam : Longint;
    Kocka: array [1..KepSzam] of integer;
    ElojelesEgy: array [1..KepSzam] of integer;
    Forgando: TImageList;
    Forgo:byte;
{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
 var i: byte;
 begin
   for i:=1 to KepSzam do
     begin
       Kocka[i] := 0;
       ElojelesEgy[i] := 1;
     end;
   mnuKiadojelClick(Sender);
 end;


procedure TForm1.mnuKilepClick(Sender: TObject);
 begin
   Form1.Close;
 end;

procedure TetelMegjelenitese(KontextSzam:word);
 begin
  { A megjelentend sgfjl nevnek megadsa:}
   Form1.HelpFile := 'TETELEK.HLP';

  { Sghvs: WinHelp32.EXE futtatsa s a megadott
    kontextszm sgfejezet megjelentse:}
   Application.HelpCommand(HELP_CONTEXT, KontextSzam);
 end;

procedure TForm1.mnuTetel1Click(Sender: TObject);
 begin
  { Kontextszmnak megfelel ttel megjelentse:}
   TetelMegjelenitese(1);
 end;

procedure TForm1.mnuTetel2Click(Sender: TObject);
 begin
   TetelMegjelenitese(2);
 end;

procedure TForm1.mnuTobbTetelClick(Sender: TObject);
 begin
   TetelMegjelenitese(0);
 end;

procedure TForm1.mnuTemakorokClick(Sender: TObject);
 begin
  { A megjelentend sgfjl nevnek megadsa:}
   Form1.HelpFile := 'SUGO_PLD.HLP';

  { Sghvs: WinHelp32.EXE futtatsa s a megadott
    kontextszm sgfejezet megjelentse:}
   Application.HelpCommand(HELP_FINDER, 0);
 end;

procedure KepMegjelenites(Kocka:integer; Lista: TImageList);
 begin
   { A kpek megjelentsi jellemzi: }
   Lista.BkColor:=clBtnFace;
   Lista.Masked:=false;

   { Az Kocka-dik kpkocka megjelentse: }
   Lista.GetBitmap(Kocka, Form1.imgKep.Picture.Bitmap);
   Form1.imgKep.Refresh;

   { A megjelentnd kplista: }
   Forgando:= Lista;
 end;

procedure TForm1.mnuRozsaClick(Sender: TObject);
 begin
   KepMegjelenites(0,imlRozsa);
 //  A megjelentnd kplista sorszma, ami a kpforgatshoz
 //  hasznlt vltozkban szksges:
   Forgo:=1;
 end;

procedure TForm1.mnuKutyusClick(Sender: TObject);
 begin
   KepMegjelenites(0,imlKutyus);
   Forgo:=2;
 end;

procedure TForm1.mnuKiadojelClick(Sender: TObject);
 begin
   KepMegjelenites(0,imlKiadojel);
   Forgo:=3;
 end;

procedure Lepkedes(Forgo:byte; Lista: TImageList);
 begin
   { Szmll rtknek nvelse/cskkense:}
   Kocka[Forgo] := Kocka[Forgo] + ElojelesEgy[Forgo];

   case Forgo of
     2: if Kocka[Forgo] = Lista.Count
           then Kocka[Forgo]:=0;

     1, 3: { Ha elrtk a kpsorozat els, illetve utols
             kpkockt (az i szmll tllpte a sorozat
             als, illetve fels indexhatrt):}

        if (Kocka[Forgo] = -1) or (Kocka[Forgo] = Lista.Count)
          then
            begin
             { Forgsirny vltsa:}
              ElojelesEgy[Forgo]:= ElojelesEgy[Forgo]*(-1);

             { Visszalps a msodik, illetve az utols
               eltti kpkockra:}
              Kocka[Forgo]:= Kocka[Forgo]+2*ElojelesEgy[Forgo];
            end;
   end;

  { A Kocka index kpkocka megjelentse:}
   KepMegjelenites(Kocka[Forgo], Lista);
 end;


procedure TForm1.tmrIdozitoTimer(Sender: TObject);
 begin
    Lepkedes(Forgo,Forgando);
 end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
 begin
   KontextSzam := Form1.HelpContext;
 end;

procedure TForm1.cmdStartMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
 begin
   KontextSzam := cmdStart.HelpContext;
 end;


procedure TForm1.cmdStartClick(Sender: TObject);
 Const
   szStart = 'Start';
   szStop = 'Stop';
 begin
    { A Start/Stop gomb feliratnak megfelelen
      elindtjk, illetve meglltjuk (Interval = 0)
      az animcit, s trjuk a gomb feliratt:}
      if cmdStart.Caption = szStop then
        begin
          tmrIdozito.Interval:= 0;
          cmdStart.Caption:= szStart;
        end
      else
        begin
          tmrIdozito.Interval:= 100;
          cmdStart.Caption:= szStop;
        end;
 end;


end.
